<html>
<head>
<title><%get_info("XE_Title");%></title>
<link href="../style/webgui.css" rel="stylesheet" type="text/css">
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<script language="JavaScript" src="../js/prompt.js"></script>
<script language="JavaScript" src="../js/overlib.js"></script>
<script language="JavaScript" src="../js/validate.js"></script>
<script language="JavaScript" src="../js/lang.js"></script>
<script language="javascript" src="../js/jquery.js"></script>
<!--language file start -->
<script language="JavaScript" src="../js/cookie.js"></script>
<script language="JavaScript" src="../mlang/mlang.js"></script>
<script language="JavaScript" src="../mlang/router.js"></script>
<script language="JavaScript" src="../mlang/showError.js"></script>
<!--language file end -->
<!--authority protect begin -->
<script language="JavaScript" src="../js/protect.js"></script>
<!--authority protect end -->
<!--chcek ip format lib begin -->
<script language="JavaScript" src="../js/check_ip.js"></script>
<!--chcek ip format lib end -->
<script language="JavaScript" type="text/javascript">
//Butterlate.setTextDomain("router");
/*
var lan_ipaddr = ' asp_get("lan_ipaddr"); %>';
var lan_netmask = ' asp_get("lan_netmask"); %>';
var lanMac = ' asp_get("mac_address"); %>';
var dhcpStart = ' asp_get("dhcpStart"); %>';
var dhcpEnd = ' asp_get("dhcpEnd"); %>';
var dhcpLease_hour = ' asp_get("dhcpLease_hour"); %>';
*/
var dhcpType = <%get_info("XD_EnableDHCP");%>;
//var pppstate = '< asp_get("ppp_status"); %>';

var secs;
var timerID = null;
var timerRunning = false;
function StartTheTimer()
{
	if (secs==0)
	{
		TimeoutReload(5);
		window.location.href=window.location.href;
    }
	else
	{
        self.status = secs;
        secs = secs - 1;
        timerRunning = true;
        timerID = self.setTimeout("StartTheTimer()", 1000);
    }
}

function TimeoutReload(timeout)
{
	secs = timeout;
	if(timerRunning)
	{
		clearTimeout(timerID);
	}
	timerRunning = false;
	StartTheTimer();	
}

function DHCP_Change()
{
	if(document.router_lan.dhcp_type.options.selectedIndex == 0 )
	{
		document.getElementById('IP_Tool').style.display = "";
	}
	if(document.router_lan.dhcp_type.options.selectedIndex == 1 )
	{
		document.getElementById('IP_Tool').style.display = "none";
	}
}

function initTranslation()
{
	
	var e;// = document.getElementById("RouterLanTitle");
	//e.innerHTML = Get_string("Router Lan Title");

	//e = document.getElementById("adv_sec_title_status");
	//e.innerHTML = Get_string('adv sec title status');
	
	//e = document.getElementById("adv_sec_title_statistics");
	//e.innerHTML = Get_string('adv statistics title statistics');
	
	//e = document.getElementById("adv_sec_title_restore");
	//e.innerHTML = Get_string('adv sec title restore');
	
	//e = document.getElementById("adv_sec_title_pin_manage");
	//e.innerHTML = Get_string('adv sec title pin manage');
	
	//e = document.getElementById("adv_sec_title_router");
	//e.innerHTML = Get_string('adv_sec_title_router');
	
	e = document.getElementById("RouterLanSubTitle");
	e.innerHTML = Router_Lan_Sub_Title[lang_index];
	
	e = document.getElementById("RouterLanIPAddress");
	e.innerHTML = Router_Lan_IP_Address[lang_index];
	
	e = document.getElementById("RouterLanSubnetMask");
	e.innerHTML = Router_Lan_Subnet_Mask[lang_index];
	
	e = document.getElementById("RouterLanMACAddress");
	e.innerHTML = Router_Lan_MAC_Address[lang_index];

	e = document.getElementById("RouterLanDHCPType");
	e.innerHTML = Router_Lan_DHCP_Type[lang_index];
	
	e = document.getElementById("RouterLanDHCPTypeDisable");
	e.innerHTML = Router_Lan_DHCP_Type_Disable[lang_index];
	
	e = document.getElementById("RouterLanDHCPTypeEnable");
	e.innerHTML = Router_Lan_DHCP_Type_Server[lang_index];
	
	e = document.getElementById("RouterLanDHCPIpPool");
	e.innerHTML = Router_Lan_DHCP_IP_Pool[lang_index];
	
	e = document.getElementById("RouterLanDHCPLease");
	e.innerHTML = Router_Lan_DHCP_Lease[lang_index];
	
	e = document.getElementById("RouterLanDHCPLeaseUnit");
	e.innerHTML = Router_Lan_DHCP_Lease_Unit[lang_index];
	
	
	e = document.getElementById("RouterLanApply");
	e.disabled = true;
	e.disabled = false;
	e.value = Router_Lan_Apply[lang_index];
	
/*	
	e = document.getElementById("RouterLanCancel");
	e.value = Router_Lan_Cancel[lang_index];	*/
}

function initValue()
{
	if(1 == dhcpType)
	{
		document.router_lan.dhcp_type.selectedIndex=0;
	}
	else
	{
		document.router_lan.dhcp_type.selectedIndex=1;
	}
	DHCP_Change();
	
	var lease_time_minute = <%get_info("XD_LeaseTime");%>;
	var lease_time_hour = Math.floor(lease_time_minute/60);
	document.getElementById('dhcpLease').value = lease_time_hour;
	
}


function initPage()
{
	initTranslation();
	initValue();
}

function atoi(str, num)
{
	i = 1;
	if (num != 1) 
	{
		while (i != num && str.length != 0) 
		{
			if (str.charAt(0) == '.') 
			{
				i++;
			}
			str = str.substring(1);
		}
		if (i != num)
			return -1;
	}

	for (i=0; i<str.length; i++) 
	{
		if (str.charAt(i) == '.') 
		{
			str = str.substring(0, i);
			break;
		}
	}
	if (str.length == 0)
		return -1;
	if((('0' == str.charAt(0)) && (1 != str.length)))
	    return -1;
	 	
	return parseInt(str, 10);
}
function checkRange(str, num, min, max)
{
	d = atoi(str, num);
	if (d > max || d < min)
		return false;
	return true;
}

function isAllNum(str)
{
	var dot_count = 0;
	for (var i=0; i<str.length; i++) 
	{
		if ((str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) == '.' ))
			continue;
		return false;
	}
	for(var i=0; i<str.length; i++)
	{
		if(str.charAt(i) == '.')
		{
			dot_count++;
		}
	}
	if(dot_count>3)
	{
		return false;
	}
	return true;
}
/************************* added by lixuzhen begin **********************/
/* type: 1, just check gateway_obj
   type: 2, check gateway_obj and netmask_obj
   type: 3, check gateway_obj, netmask_obj ip_src_obj and ip_dst_obj
*/
function check_ip(gateway_obj, netmask_obj, ip_src_obj, ip_dst_obj, type)
{
	// step.1 check ip format.
	if(3 == type)
	{
		if(!check_ip_format(ip_src_obj.value))
		{
			ShowError(ip_src_obj, IP_format_error[lang_index]);
			return false;
		}
		if(!check_ip_format(ip_dst_obj.value))
		{
			ShowError(ip_dst_obj, IP_format_error[lang_index]);
			return false;
		}
	}
	if((3 == type) || (2 == type))
	{
		if(!check_ip_format(netmask_obj.value))
		{
			ShowError(netmask_obj, Router_Lan_NetMask_Invalid[lang_index]);
			return false;
		}
	}
	if((3 == type) || (2 == type) || (1 == type))
	{
		if(!check_ip_format(gateway_obj.value))
		{
			ShowError(gateway_obj, IP_format_error[lang_index]);
			return false;
		}
	}
	
	//find ip class type
	var ip_class = find_network_type(gateway_obj.value);
	if((ip_class < 1) || (ip_class > 4))
	{
		ShowError(gateway_obj, IP_format_error[lang_index]);
		return false;
	}
	
	//check networ mask
	if((3 == type) || (2 == type))
	{
		if(!check_netmask(ip_class, netmask_obj.value))
		{
			ShowError(netmask_obj, Router_Lan_NetMask_Invalid[lang_index]);
			return false;
		}
	}
	
	//check dhcp start and end ip
	if(3 == type)
	{
		var left_compare_result = compare_host_id(ip_src_obj.value, gateway_obj.value, netmask_obj.value);
		if(left_compare_result < 1)
		{
			ShowError(ip_src_obj, Router_Lan_DHCP_SIP_Out_Range[lang_index]);
			return false;
		}
		var right_compare_result = compare_host_id(ip_dst_obj.value, gateway_obj.value, netmask_obj.value);
		if(right_compare_result < 1)
		{
			ShowError(ip_dst_obj, Router_Lan_DHCP_EIP_Out_Range[lang_index]);
			return false;
		}
		if(left_compare_result != right_compare_result)
		{
			ShowError(ip_src_obj, Router_Lan_DHCP_SIP_Out_Range[lang_index]);
			return false;
		}
	}
	return true;
}
/************************* added by lixuzhen end ************************/


function checkIpAddr(field, ismask)
{
	if (field.value == "") {
		if(field.name=='ip_address')
		{
			ShowError(field, Not_set_IP_addr[lang_index]);
			field.focus();
			return false;
		}
		else
		{
			ShowError(field, Not_set_IP_addr[lang_index]);
			field.focus();
			return false;
		}
	}

	if (isAllNum(field.value) == 0) {
		if(field.name=='ip_address')
		{
			ShowError(field, IP_format_error[lang_index]);
			field.focus();
			return false;
		}
		else
		{
			ShowError(field, IP_format_error[lang_index]);
			//field.value = field.defaultValue;
			field.focus();
			return false;
		}
	}

	if (ismask) {
		if ((!checkRange(field.value, 1, 1, 255)) ||
				(!checkRange(field.value, 2, 0, 256)) ||
				(!checkRange(field.value, 3, 0, 256)) ||
				(!checkRange(field.value, 4, 0, 256)))
		{
			ShowError(field, IP_format_error[lang_index]);
			//field.value = field.defaultValue;
			field.focus();
			return false;
		}
	}
	else {
		//if ((!checkRange(field.value, 1, 0, 255)) ||
		if ((!checkRange(field.value, 1, 1, 223)) ||
				(!checkRange(field.value, 2, 0, 255)) ||
				(!checkRange(field.value, 3, 0, 255)) ||
				(!checkRange(field.value, 4, 1, 254)))
		{
			if(field.name=='ip_address')
			{
				ShowError(field, IP_format_error[lang_index]);
				//field.value = field.defaultValue;
				field.focus();
				return false;
			}
		else
			{
				ShowError(field, IP_format_error[lang_index]);
				//field.value = field.defaultValue;
				field.focus();
				return false;
			}
		}
	}
	return true;
}


function hex(val)
{
	var h = (val-0).toString(16);
	if(h.length==1) h='0'+h;
	return h.toUpperCase();
}
function Op_AND_4Byte(v1, v2) {
	var i;
	var var1 = new Array();
	var var2 = new Array();
	var result='0x';

	for (i=2,j=0;i<10;i+=2,j++) {
		var1[j]='0x'+v1.substring(i,i+2);
		var2[j]='0x'+v2.substring(i,i+2);
	}
	
	for (i=0;i<4;i++) {
		result = result + hex(var1[i]&var2[i]);
	}
	
	result = result-0;
	return result;
}

function validateGateway(wanIp,netmaskIp,gatewayIp) {

	var i1,i2,i3, wip, nip, gip;
	var lan4, mask4, pool4, net_no, lo_broadcast;

	i1=wanIp.indexOf('.');
	i2=wanIp.indexOf('.',(i1+1));
	i3=wanIp.indexOf('.',(i2+1));
	wip = hex(wanIp.substring(0,i1)) + hex(wanIp.substring((i1+1),i2)) +hex(wanIp.substring((i2+1),i3))+hex(wanIp.substring((i3+1),wanIp.length));
	wip = '0x'+wip;
	lan4 = wanIp.substring((i3+1),wanIp.length)-0;
	
	i1=netmaskIp.indexOf('.');
	i2=netmaskIp.indexOf('.',(i1+1));
	i3=netmaskIp.indexOf('.',(i2+1));
	nip = hex(netmaskIp.substring(0,i1)) + hex(netmaskIp.substring((i1+1),i2)) +hex(netmaskIp.substring((i2+1),i3)) +hex(netmaskIp.substring((i3+1),netmaskIp.length));
	nip = '0x'+nip;
	mask4 = netmaskIp.substring((i3+1),netmaskIp.length)-0;

	i1=gatewayIp.indexOf('.');
	i2=gatewayIp.indexOf('.',(i1+1));
	i3=gatewayIp.indexOf('.',(i2+1));
	gip = hex(gatewayIp.substring(0,i1)) + hex(gatewayIp.substring((i1+1),i2)) +hex(gatewayIp.substring((i2+1),i3)) +hex(gatewayIp.substring((i3+1),gatewayIp.length));
	gip = '0x'+gip;
	pool4 = gatewayIp.substring((i3+1),gatewayIp.length)-0;
	
	if (Op_AND_4Byte(wip, nip) != Op_AND_4Byte(gip, nip))
	{
		//alert("Invalid Ip: " +gatewayIp+" not in " + wanIp+"/"+netmaskIp+" netmask");
		return false;
	}

	net_no = (lan4 & mask4);
	lo_broadcast =  (lan4 & mask4) + (255-mask4);
	
	if (pool4==net_no) {
		//alert("Invalid Ip: " +gatewayIp+" is the Network Number.");
		return false;
	}
	if (pool4==lo_broadcast) {
		//alert("Invalid Ip: " +gatewayIp+" is the Broadcast address.");
		return false;
	}
}

function validateStartEndIp(lan_ipaddr, netip, startip, endip)
{
	i1=startip.indexOf('.');
	i2=startip.indexOf('.',(i1+1));
	i3=startip.indexOf('.',(i2+1));
	sip = hex(startip.substring(0,i1)) + hex(startip.substring((i1+1),i2)) +hex(startip.substring((i2+1),i3))+hex(startip.substring((i3+1),startip.length));
	sip = '0x'+sip;

	i1=endip.indexOf('.');
	i2=endip.indexOf('.',(i1+1));
	i3=endip.indexOf('.',(i2+1));
	eip = hex(endip.substring(0,i1)) + hex(endip.substring((i1+1),i2)) +hex(endip.substring((i2+1),i3))+hex(endip.substring((i3+1),endip.length));
	eip = '0x'+eip;
	
	i1=lan_ipaddr.indexOf('.');
	i2=lan_ipaddr.indexOf('.',(i1+1));
	i3=lan_ipaddr.indexOf('.',(i2+1)); 
	lan_ipaddr = hex(lan_ipaddr.substring(0,i1)) + hex(lan_ipaddr.substring((i1+1),i2)) +hex(lan_ipaddr.substring((i2+1),i3))+hex(lan_ipaddr.substring((i3+1),lan_ipaddr.length));
	lan_ipaddr = '0x'+lan_ipaddr;

	if(sip>eip)
	{
		//alert("Invalid start and end IP address, end IP should be larger than start IP.");
		return 1;
	}
	
	if(lan_ipaddr >= sip && lan_ipaddr <= eip)
	{
	    return 2;
	}
	
	return 0;
}
function isNetmaskIPValid(ip)
{
	if (ip == 255 || ip == 254 || ip == 252 || ip == 248
	|| ip == 240 || ip == 224 || ip == 192 || ip == 128 || ip == 0)
	{
		return true;
	}
	else
	{
		return false;
	}
}

function validateNetmask(netmask)
{
	var array = new Array();
	array = netmask.split(".");
	
	if (array.length != 4)
	{
		return false;
	}
	
	array[0] = parseInt(array[0]);
	array[1] = parseInt(array[1]);
	array[2] = parseInt(array[2]);
	array[3] = parseInt(array[3]);

	if (array[3] != 0)
	{
		if (array[2] != 255 || array[1] != 255 || array[0] != 255)
		{
			return false;
		}
//		else
//		{
		if (!isNetmaskIPValid(array[3]))
		{
			return false;
		}
//		}
	}
	
	if (array[2] != 0)
	{
		if (array[1] != 255 || array[0] != 255)
		{
			return false;
		}
//		else
//		{
		if (!isNetmaskIPValid(array[2]))
		{
			return false;
		}
//		}
	}
	
	if (array[1] != 0)
	{
		if (array[0] != 255)
		{
			return false;
		}
//		else
//		{
		if (!isNetmaskIPValid(array[1]))
		{
			return false;
		}
//		}
	}
	if((array[0] == 0) && (array[1] == 0) && (array[2] == 0) &&(array[3] == 0))
	{
		return false;
	}
	if((array[0] == 255) && (array[1] == 255) && (array[2] == 255) &&(array[3] == 255))
	{
		return false;
	}
	
	return true;
}
function check_specific_lan_ip(lan_ip)
{
	if(0 != lan_ip.indexOf('192.168.1.'))
	{
		return false;
	}
	return true;
}
function CheckValue()
{
	//if(document.router_lan.dhcpLease.value>24||document.router_lan.dhcpLease.value<=0)
	var check_dhcp_type;
	if(document.router_lan.dhcp_type.options.selectedIndex == 0)
	{
		check_dhcp_type = 3;
	}
	else
	{
		check_dhcp_type = 2;
	}
	
	if(!check_ip(document.router_lan.ip_address, document.router_lan.subnet_mask, document.router_lan.ip_pool_1, document.router_lan.ip_pool_2, check_dhcp_type))
	{
		return false;
	}

	if (!checkIpAddr(document.router_lan.ip_address, false))
	{
		return false;
	}
	if (!checkIpAddr(document.router_lan.subnet_mask, true))
	{
		return false;
	}
	

	// check the netmask address by LiuWei184577
	if ( !validateNetmask(document.router_lan.subnet_mask.value) )
	{
		ShowError(document.router_lan.subnet_mask, Invalid_Subnet_mask[lang_index]);
		document.router_lan.subnet_mask.focus();
		return false;
	}
	

	if (document.router_lan.dhcp_type.options.selectedIndex == 0) 
	{
		if (!checkIpAddr(document.router_lan.ip_pool_1, false))
		{
			return false;
		}
			
		var startIp = document.router_lan.ip_pool_1.value;
		var startIpArrays = startIp.split(".");
		if (startIpArrays.length >= 4)
		{
			startIpArrays[3] = 254;
		}
		var endIp = startIpArrays[0] + "." + startIpArrays[1] + "." + startIpArrays[2] + "." + startIpArrays[3];
		
		if (!checkIpAddr(document.router_lan.ip_pool_2, false))
		{
			return false;
		}
			
		if(validateGateway(document.router_lan.ip_address.value, document.router_lan.subnet_mask.value, document.router_lan.ip_pool_1.value)==false)
		{
		    ShowError(document.router_lan.ip_pool_1, Router_Lan_DHCP_SIP_Out_Range[lang_index]);
		    return false;
		}
		
		if(validateGateway(document.router_lan.ip_address.value, document.router_lan.subnet_mask.value, document.router_lan.ip_pool_2.value)==false)
		{
		    ShowError(document.router_lan.ip_pool_2, Router_Lan_DHCP_EIP_Out_Range[lang_index]);
		    return false;
		}	
		
		if(validateStartEndIp(document.router_lan.ip_address.value, document.router_lan.subnet_mask.value,
		    document.router_lan.ip_pool_1.value, document.router_lan.ip_pool_2.value)==1)
		{
		    ShowError(document.router_lan.ip_pool_2, Router_Lan_DHCP_Pool_Error[lang_index]);
			return false;
		}
		else if(validateStartEndIp(document.router_lan.ip_address.value, document.router_lan.subnet_mask.value,
		    document.router_lan.ip_pool_1.value, document.router_lan.ip_pool_2.value)==2)
		{
			ShowError(document.router_lan.ip_address, Router_Lan_DHCP_Pool_Same[lang_index] );
			return false;
		}
	}
	if(isNaN(document.getElementById('dhcpLease').value)||document.getElementById('dhcpLease').value.indexOf("-")!= -1||document.getElementById('dhcpLease').value.indexOf(".")!= -1 )
	{
		ShowError(document.router_lan.dhcpLease, Router_Lan_DHCP_Lease_Error[lang_index]  );
		return false;	
	}
	
//	if(is_change())
//	{
		return confirm(Router_Lan_DHCP_Close[lang_index]);
//	}
//	else
//	{
//		document.location.reload();
//		return false;
//	}
}

function is_change()
{
	var dhcp_info = $.ajax({url: "/goform/dhcp_cmd?cmd=all",async: false}).responseText;
	var dhcp_info_array = dhcp_info.split("<!#@>");
	if($("#ip_address").attr("value") != dhcp_info_array[0])
	{
		return 1;
	}
	
	if($("#subnet_mask").attr("value") != dhcp_info_array[1])
	{
		return 1;
	}
	
	if($("#dhcp_type").attr("selectedIndex") != parseInt(dhcp_info_array[2]))
	{
		return 1;
	}
	
	if($("#ip_pool_1").attr("value") != dhcp_info_array[3])
	{
		return 1;
	}
	
	if($("#ip_pool_2").attr("value") != dhcp_info_array[4])
	{
		return 1;
	}
	return 0;
}

</script>
</head>

<body class="subpage_body_web" onLoad="initPage();">
<!-- ================= showerror div begin================= -->
<div id="MsgLayer1" onClick="setinner('hidden')"></div>
<div id="MsgLayer2" onClick="setinner('hidden')">
    <div id="errLayer" >
        <table height="48" width="320" border="0">
            <tr>
                <td width="320" align="center"><div id="errmsg" name="errmsg"></div></td>
            </tr>
        </table>
    </div>
</div>
<iframe id="ifr" name="ifr" src="about:blank">	</iframe>
<!-- ================= showerror div end================= -->
<!-- ================= toptip div begin================= -->
<div id="overDiv" name="overDiv"></div>
<!-- ================= toptip div end================= -->
 <form name="router_lan" id="router_lan" onSubmit="return CheckValue();" action="/goform/wlan_set_dhcp_profile"  method="post">
<table cellspacing="0" cellpadding="0" border="0" width="100%">
    <tr>
        <td valign="top">
        
		<input type="hidden" value="DHCP_SET" name="goformId" id="goformId">
        <input type="hidden" value="" name="lucknum_DHCP_SET" id="lucknum_DHCP_SET">
        <table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td class="labelfont" colspan="2" id="RouterLanSubTitle">DHCP Settings</td>
        </tr>
        <tr>
          <td width="30%" class="top_head" id="RouterLanIPAddress">IP Address</td>
          <td class="tail"><input id="ip_address" name="ip_address" maxlength="15" value="<%get_info("XD_GatewayIPAddr");%>"></td>
        </tr>
        <tr>
          <td class="top_head" id="RouterLanSubnetMask">Subnet Mask</td>
          <td class="tail"><input id="subnet_mask" name="subnet_mask" maxlength="15" value="<%get_info("XD_SubnetMask");%>"></td>
        </tr>
        
        <tr>
          <td class="top_head" id="RouterLanMACAddress">MAC Address</td>
          <td class="tail" id="lanMacAddress">&nbsp;<%get_info("N_LanMacAddress");%></td>
        </tr>
        <tr>
          <td class="top_head" id="RouterLanDHCPType">DHCP Type</td>
          <td class="tail">
            <select name="dhcp_type" id="dhcp_type" onChange="DHCP_Change();">
              <option value="Enable" id="RouterLanDHCPTypeEnable">Enable</option>
              <option value="Disable" id="RouterLanDHCPTypeDisable">Disable</option>
            </select>
          </td>
        </tr>
        </table>
        <table width="100%" border="0" cellpadding="0" cellspacing="0" id="IP_Tool">
        <tr>
          <td class="top_head" id="RouterLanDHCPIpPool" width="30%">DHCP IP Pool</td>
          <td class="tail">
            <input id="ip_pool_1" name="ip_pool_1" maxlength="15" value="<%get_info("XD_StartIPAddr");%>">&nbsp;&nbsp;-&nbsp;&nbsp;
            <input id="ip_pool_2" name="ip_pool_2" maxlength="15" value="<%get_info("XD_EndIPAddr");%>"></td>
        </tr>
        <tr >
          <td class="top_head" id="RouterLanDHCPLease">DHCP Lease Time</td>
          <td class="tail" ><input name="dhcpLease" id="dhcpLease" maxlength="5" value="">
            &nbsp;<span id="RouterLanDHCPLeaseUnit">hour(s)</span>
          </td>
        </tr>
        </table>

        </td>
    </tr>
</table>
<br>
<div class="div_btn">
            <input type="submit" class="btn" value="Apply" id="RouterLanApply" onMouseOver="this.className='menu_over'" onMouseOut="this.className='menu_out'" onMouseDown="this.className='menu_down'">
        </div>
        </form>
</body>
</html>

